import os
import requests
from bs4 import BeautifulSoup

class XUIPanel:
    def __init__(self):
        self.base_url = os.getenv("SERVICE4_PANEL_URL")
        self.username = os.getenv("SERVICE4_PANEL_USERNAME")
        self.password = os.getenv("SERVICE4_PANEL_PASSWORD")
        self.session = requests.Session()
        self.logged_in = False

    def login(self):
        login_url = f"{self.base_url}/login"
        login_data = {
            "referrer": "",
            "username": self.username,
            "password": self.password,
            "login": ""
        }
        headers = {
            "User-Agent": "Mozilla/5.0",
            "Content-Type": "application/x-www-form-urlencoded",
            "Referer": login_url
        }
        resp = self.session.post(login_url, data=login_data, headers=headers, verify=False)
        self.logged_in = resp.status_code == 200
        return self.logged_in

    def ensure_login(self):
        if not self.logged_in:
            return self.login()
        return True

    def get_package_dropdown(self):
        self.ensure_login()
        line_url = f"{self.base_url}/line"
        resp = self.session.get(line_url, headers={"User-Agent": "Mozilla/5.0"}, verify=False)
        soup = BeautifulSoup(resp.text, "html.parser")
        package_select = soup.find("select", {"name": "package_id"})
        packages = []
        if package_select:
            for option in package_select.find_all("option"):
                value = option.get("value")
                if value and value.isdigit():
                    packages.append({"id": value, "name": option.text.strip()})
        return packages

    def get_user_info(self, username):
        self.ensure_login()
        # You may need to adjust this based on Fiddler logs for your panel
        api_url = f"{self.base_url}/api"
        params = {
            "action": "get_user",
            "username": username
        }
        resp = self.session.get(api_url, params=params, headers={"X-Requested-With": "XMLHttpRequest"}, verify=False)
        try:
            return resp.json()
        except Exception:
            return {"error": "Failed to parse user info"}

    def create_user(self, package_id, username, password, connections=1, xxx=False):
        self.ensure_login()
        api_url = f"{self.base_url}/api"
        data = {
            "action": "create_user",
            "package_id": package_id,
            "username": username,
            "password": password,
            "connections": connections,
            "xxx": int(xxx)
        }
        resp = self.session.post(api_url, data=data, headers={"X-Requested-With": "XMLHttpRequest"}, verify=False)
        try:
            return resp.json()
        except Exception:
            return {"error": "Failed to create user"}

    def renew_user(self, username, package_id):
        self.ensure_login()
        api_url = f"{self.base_url}/api"
        data = {
            "action": "renew_user",
            "username": username,
            "package_id": package_id
        }
        resp = self.session.post(api_url, data=data, headers={"X-Requested-With": "XMLHttpRequest"}, verify=False)
        try:
            return resp.json()
        except Exception:
            return {"error": "Failed to renew user"}